<?php
// api/auth/token.php
require_once __DIR__ . '/../../autoload.php';

use Firebase\JWT\JWT;
use Config\AuthConfig;

header('Content-Type: application/json');

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['device_fingerprint'])) {
        throw new Exception("Missing device fingerprint");
    }

    // Create token payload
    $payload = [
        'fingerprint' => $input['device_fingerprint'],
        'iat' => time(),
        'exp' => time() + AuthConfig::JWT_EXPIRY
    ];

    $token = JWT::encode($payload, AuthConfig::JWT_KEY, 'HS256');

    echo json_encode([
        'feedback' => 'success',
        'token' => $token
    ]);

} catch (Exception $e) {
    http_response_code(401);
    echo json_encode([
        'feedback' => 'error',
        'reason' => $e->getMessage()
    ]);
}