<?php
// autoload.php
spl_autoload_register(function ($className) {
    // Convert namespace separators to directory separators
    $className = str_replace('\\', '/', $className);
    
    // Handle Firebase JWT classes
    if (strpos($className, 'Firebase/JWT/') === 0) {
        $file = __DIR__ . '/lib/' . $className . '.php';
        if (file_exists($file)) {
            require_once $file;
            return;
        }
    }
    
    // Handle Middleware classes
    if (strpos($className, 'Middleware/') === 0) {
        $file = __DIR__ . '/' . $className . '.php';
        if (file_exists($file)) {
            require_once $file;
            return;
        }
    }
    
    // Handle Model classes
    if (strpos($className, 'Models/') === 0) {
        $file = __DIR__ . '/' . $className . '.php';
        if (file_exists($file)) {
            require_once $file;
            return;
        }
    }
    
    // Handle other classes
    $file = __DIR__ . '/' . $className . '.php';
    if (file_exists($file)) {
        require_once $file;
    }
});