<?php
// middleware/AuthMiddleware.php
namespace Middleware;

use Firebase\JWT\JWT;
use Firebase\JWT\Key;
use Config\AuthConfig;

class AuthMiddleware {
    public static function authenticate() {
        try {
            $headers = getallheaders();
            
            if (!isset($headers['Authorization'])) {
                throw new \Exception("Missing authorization header");
            }

            // Extract token
            $auth = $headers['Authorization'];
            if (!preg_match('/Bearer\s+(.*)$/i', $auth, $matches)) {
                throw new \Exception("Invalid authorization format");
            }

            $token = $matches[1];
            
            try {
                $decoded = JWT::decode($token, new Key(AuthConfig::JWT_KEY, 'HS256'));
                
                if (!isset($decoded->fingerprint) || !isset($decoded->exp)) {
                    throw new \Exception("Invalid token");
                }

                if (!self::verifyAppPackage($decoded->fingerprint)) {
                    throw new \Exception("Invalid application");
                }

                return true;
            } catch (\Exception $e) {
                throw new \Exception("Invalid token");
            }

        } catch (\Exception $e) {
            http_response_code(401);
            echo json_encode([
                'feedback' => 'error',
                'reason' => $e->getMessage()
            ]);
            exit;
        }
    }

    private static function verifyAppPackage($fingerprint) {
        $data = json_decode($fingerprint, true);
        return isset($data['package']) && in_array($data['package'], AuthConfig::ALLOWED_PACKAGES);
    }
}