<?php
// api/createGameId.php
require_once __DIR__ . '/../autoload.php';

use Config\DatabaseConfig;
use Models\GameId;
use Middleware\AuthMiddleware; // Make sure this is imported

header('Content-Type: application/json');

try {
    // This line must be at the start, before any other processing
    //AuthMiddleware::authenticate();

    // Rest of your code
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['username']) || !isset($input['deviceUuid']) || !isset($input['deviceOs'])) {
        //throw new Exception("Missing required fields");
    }
    
    $pdo = DatabaseConfig::getDatabaseConnection();
    $gameIdModel = new GameId($pdo);
    
    $data = $gameIdModel->create(
        $input['username'],
        $input['deviceUuid'],
        $input['deviceOs'],
        $_SERVER['REMOTE_ADDR']
    );
    
    echo json_encode([
        'feedback' => 'success',
        'data' => $data
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'feedback' => 'error',
        'reason' => $e->getMessage()
    ]);
}