<?php
// api/restoreGameId.php
require_once __DIR__ . '/../autoload.php';

use Config\DatabaseConfig;
use Models\GameId;
use Middleware\AuthMiddleware; // Make sure this is imported

header('Content-Type: application/json');

try {
    // This line must be at the start, before any other processing
    AuthMiddleware::authenticate();

    // Rest of your code
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['gameId']) || !isset($input['username'])) {
        throw new Exception("Missing required fields");
    }
    
    $pdo = DatabaseConfig::getDatabaseConnection();
    $gameIdModel = new GameId($pdo);
    
    $data = $gameIdModel->restore($input['gameId'], $input['username']);
    
    echo json_encode([
        'feedback' => 'success',
        'data' => $data
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'feedback' => 'error',
        'reason' => $e->getMessage()
    ]);
}